<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateUsersPermissionsWeightTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('users_permissions_weight', function (Blueprint $table) {
            $table->increments('id');
            $table->unsignedInteger('user_id');
            $table->unsignedInteger('object_id');
            $table->unsignedInteger('weight')->default(0)->comment('Общий вес разрешений пользователя');

            $table
                ->foreign('user_id')->references('id')
                ->on('users')->onDelete('cascade');

            $table->foreign('object_id')->references('id')->on('objects');

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('users_permissions_weight');
    }
}
