<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class ChangeColumnClaimId extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up() {
        if (Schema::hasColumn('claim_images', 'claim_id')) {
            Schema::table('claim_images', function (Blueprint $table) {
                $table->dropColumn('claim_id');
            });
        }

        Schema::table('claim_images', function (Blueprint $table) {
            $table->integer('claim_id')->unsigned();
            $table->foreign('claim_id')->references('id')->on('claims')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down() {
        Schema::table('claim_images', function (Blueprint $table) {
            $table->dropForeign(['claim_id']);
        });
    }
}
