<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class UpdatePremissionsTables extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        // Adding object_id foreign key
        Schema::table('role_users', function (Blueprint $table) {
            $table
                ->unsignedInteger('object_id')
                ->default(1)
                ->after('role_id');

            $table
                ->foreign('object_id')
                ->references('id')->on('objects')
                ->onDelete('cascade');
        });

        // Change primary key
        DB::statement('
            ALTER TABLE `role_users`
            ADD PRIMARY KEY `role_id_user_id_object_id` (`role_id`, `user_id`, `object_id`),
            DROP INDEX `PRIMARY`
        ');

        // Removing default value of object_id column
        Schema::table('role_users', function (Blueprint $table) {
            $table
                ->unsignedInteger('object_id')
                ->default(null)
                ->change();
        });

        DB::table('permission_roles')->where('object_id', '<>', 1)->delete();

        Schema::table('permission_roles', function (Blueprint $table) {
            // Change primary key
            DB::statement('
                ALTER TABLE `permission_roles`
                ADD PRIMARY KEY `permission_id_role_id` (`permission_id`, `role_id`),
                DROP INDEX `PRIMARY`
            ');

            // Drop object_id foreign key
            $table->dropForeign(['object_id']);
            $table->dropColumn('object_id');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        // Adding object_id foreign key
        Schema::table('permission_roles', function (Blueprint $table) {
            $table
                ->unsignedInteger('object_id')
                ->default(1)
                ->after('role_id');

            $table
                ->foreign('object_id')
                ->references('id')->on('objects')
                ->onDelete('cascade');
        });

        // Change primary key
        DB::statement('
            ALTER TABLE `permission_roles`
            ADD PRIMARY KEY `permission_id_role_id_object_id` (`permission_id`, `role_id`, `object_id`),
            DROP INDEX `PRIMARY`
        ');

        // Removing default value of object_id column
        Schema::table('permission_roles', function (Blueprint $table) {
            $table
                ->unsignedInteger('object_id')
                ->default(null)
                ->change();
        });

        Schema::table('role_users', function (Blueprint $table) {
            // Change primary key
            DB::statement('
                ALTER TABLE `role_users`
                ADD PRIMARY KEY `role_id_user_id` (`role_id`, `user_id`),
                DROP INDEX `PRIMARY`
            ');

            // Drop object_id foreign key
            $table->dropForeign(['object_id']);
            $table->dropColumn('object_id');
        });
    }
}
