<?php

use Illuminate\Support\Facades\DB;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class FillApartmentIdInDeviceTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        // should fill newly created 'apartment_id' field
        DB::statement('
          update devices as d set apartment_id = (
            select au.apartment_id
            from oauth_access_tokens as oat
            left join apartment_user as au on au.user_id = oat.user_id
            where d.id=oat.id
          )
        ');
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        // no need to delete values, because column will be dropped
    }
}
