<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddObjectIdColumnInCamerasTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('cameras', function (Blueprint $table) {
            $object = \App\Models\Building::first();
            $cameras = \App\Models\Camera::first();
            if ($cameras && $object) {
                $table->integer('object_id')->after('rtsp_link')->default($object->id);
            } else {
                $table->integer('object_id')->after('rtsp_link');
            }
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('cameras', function (Blueprint $table) {
            $table->dropColumn(['object_id']);
        });
    }
}
