<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class DropUniqueIndexFromApartmentNumber extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('apartments', function(Blueprint $table)
        {
            $table->dropUnique(['number']);
            $table->unique(['number', 'object_id']);

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('apartments', function(Blueprint $table)
        {
            $table->dropUnique(['number', 'object_id']);
            $table->unique(['number']);

        });
    }
}
