<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateSipNumbersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('sip_numbers', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('apartment_id')->references('id')->on('apartments')->onDelete('cascade');
            $table->string('sip_number', 255)->unique();
            $table->string('sip_password', 255);
            $table->string('token')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('sip_numbers');
    }
}
