<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class ChangeRelationsForQuizWithResults extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('quiz_result', function (Blueprint $table) {
            $table->dropForeign('quiz_result_quiz_answer_id_foreign');
            $table->foreign('quiz_answer_id')
                ->references('id')->on('quiz_answer')
                ->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('quiz_result', function (Blueprint $table) {
            $table->dropForeign('quiz_result_quiz_answer_id_foreign');
            $table->foreign('quiz_answer_id')
                ->references('id')->on('quiz_answer');
        });
    }
}
