<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class DropFieldsFromCameras extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('cameras', function (Blueprint $table) {
            $table->dropColumn([
                'model',
                'ip_address',
                'port',
                'login',
                'camera_password',
                'sip_number',
            ]);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('cameras', function (Blueprint $table) {
            $table->string('model')->nullable()->comment('Модель камеры');
            $table->string('ip_address')->nullable()->comment('IP адрес камеры');
            $table->string('port')->nullable()->comment('Порт камеры');
            $table->string('login')->nullable()->comment('Логин для подключения к камере');
            $table->string('camera_password')->nullable()->comment('Пароль для подключения к камере');
            $table->string('sip_number')->nullable()->comment('SIP номер для подключения к камере');
        });
    }
}
