<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateClaimTables extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
      Schema::create('claim_type', function (Blueprint $table) {
        $table->increments('id');
        $table->string('text', 255)->comment('текст типа заявки');
        $table->timestamps();
      });
      Schema::create('claims', function (Blueprint $table) {
        $table->increments('id');
        $table->integer('user_id')->unsigned();
        $table->timestamp('need_at')->comment('желаемая дата заявки');
        $table->integer('type_id')->unsigned()->comment('тип заявки');
        $table->foreign('type_id')->references('id')->on('claim_type')->onDelete('cascade');
        $table->string('phone', 11)->nullable()->comment('номер телефона отправителя заявки');
        $table->integer('status')->comment('статус заявки');
        $table->timestamps();
      });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('claims');
        Schema::dropIfExists('claim_type');
    }
}
