<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddForeignKeyToAdvertsDestinations extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('adverts_destinations', function (Blueprint $table) {
            $table
                ->foreign('advert_id')
                ->references('id')
                ->on('adverts')
                ->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('adverts_destinations', function (Blueprint $table) {
            $table->dropForeign('adverts_destinations_advert_id_foreign');
        });
    }
}
