<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

/**
 * Class ChangeEntranceAndFloorFieldsInApartmentsTable
 *
 * In this migration changed types of several fields:
 *      - `entrance`: from UNSIGNED INT to VARCHAR
 *      - `floor`: from UNSIGNED INT to INT
 */
class ChangeEntranceAndFloorFieldsInApartmentsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('apartments', function (Blueprint $table) {
            $table->string('entrance')->change();
            $table->integer('floor')->change();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('apartments', function (Blueprint $table) {
            $table->integer('entrance')->unsigned()->change();
            $table->integer('floor')->unsigned()->change();
        });
    }
}
