<?php

namespace App\Traits;

use App\Models\ClaimType;

/**
 * Trait UseClaimTypes
 *
 * @property \Illuminate\Database\Eloquent\Collection $claimTypes
 *
 * @package App\Traits
 *
 * @mixin \Illuminate\Database\Eloquent\Model
 */
trait UseClaimTypes
{

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsToMany
     */
    public function claimTypes()
    {
        return $this->belongsToMany(ClaimType::class, 'user_claim_types');
    }
}