<?php

namespace App\Traits\PermissionManager;

use Illuminate\Support\Facades\DB;

trait GroupPermission
{
    /**
     * Устанавливает права из одной группы, обладающие меньшим весом
     *
     * @return \Backpack\CRUD\app\Http\Requests\CrudRequest
     */
    private function setGroupPermissions($request)
    {
        // Создать запрос для получения списка групп для текущих прав
        $input_permissions = $request->input('permissions_show');

        // Получить группы для текущих прав и их веса
        $permissions_query = DB::table('permissions')->select('id', 'weight', 'group_id');
        foreach ($input_permissions as $input_permission) {
            $permissions_query = $permissions_query->orWhere('id', $input_permission);
        }

        $raw_permissions = $permissions_query->get();

        // Сгруппировать текущие права
        foreach ($raw_permissions as $raw_permission) {
            $groups[$raw_permission->group_id][$raw_permission->id] = $raw_permission->weight;
        }

        // Получить максимальный вес для группы
        $groups_weights = [];

        foreach ($groups as $group_id => $group) {
            // Просмотр группы
            $max_weight = 0;
            foreach ($group as $permission) {
                if ($permission > $max_weight) {
                    $max_weight = $permission;
                }
            }

            $groups_weights[$group_id] = $max_weight;
        }

        // Выбрать все права для групп, веса которых меньше или равны текущему
        $permissions = [];
        foreach ($groups_weights as $group_id => $weight) {
            $permissions = array_merge($permissions, DB::table('permissions')->select('id')
                ->where('weight', '<', $weight)
                ->where('group_id', $group_id)
                ->get()->toArray());
        }

        // Привести массив к стандартному виду
        $prepared_base_permissions = [];
        foreach ($permissions as $permission) {
            $prepared_base_permissions[] = (string)$permission->id;
        }

        // Включить в данный массив входящие права
        $prepared_permissions = array_merge($prepared_base_permissions, $input_permissions);

        // Внести в запрос обновленные данные
        $request->request->add(['permissions' => $prepared_permissions, 'permissions_show' => $prepared_permissions]);

        return $request;
    }
}