<?php

namespace App\Rules\Rtsp;

use Illuminate\Contracts\Validation\Rule;

class Rtspname implements Rule
{
    /**
     * Determine if the validation rule passes.
     *
     * @param  string  $attribute
     * @param  mixed  $value
     * @return bool
     */
    public function passes($attribute, $value)
    {
        $pattern = '/^([a-z0-9$_\.\+!\*\'\(\),;\?&=-]|%[0-9a-f]{2})+$/i';

        if (preg_match($pattern, $value)) {
            return true;
        }

        return false;
    }

    /**
     * Get the validation error message.
     *
     * @return string
     */
    public function message()
    {
        return trans('validation.rtspname');
    }
}
