<?php

namespace App\Providers;

use Illuminate\Support\Facades\Response;
use Illuminate\Support\ServiceProvider;

/**
 * Class ResponseServiceProvider
 *
 * @package App\Providers
 */
class ResponseServiceProvider extends ServiceProvider
{
    /**
     * Bootstrap services.
     *
     * @return void
     */
    public function boot()
    {
        Response::macro(
            'errorJson',
            function (
                string $message,
                int $status,
                array $headers = [],
                int $options = 0,
                array $additionalData = []
            ) {
                $data = array_merge($additionalData, [
                    'error' => [
                        'code' => $status,
                        'message' => $message,
                    ],
                ]);

                return Response::make($data, $status, $headers, $options);
            }
        );
    }

    /**
     * Register services.
     *
     * @return void
     */
    public function register()
    {
        //
    }
}
