<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Notification;
use NotificationChannels\Gcm\GcmChannel;
use NotificationChannels\Gcm\GcmMessage;

class ClaimStatusChangingDefault extends Notification
{
    use Queueable;

    public $message;

    public function __construct($message = "")
    {
        $this->message = $message;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @return array
     */
    public function via()
    {
        return [GcmChannel::class];
    }

    /**
     * Get the mail representation of the notification.
     *
     * @param  mixed $notifiable
     * @return \NotificationChannels\Gcm\GcmMessage;
     */
    public function toGcm($notifiable)
    {
        return GcmMessage::create()
            ->badge(1)
            ->title(__('claims.notifications.status_change', [], $notifiable->locale))
            ->message($this->message)
            ->priority('high');
    }

    /**
     * Get the array representation of the notification.
     *
     * @param  mixed $notifiable
     * @return array
     */
    public function toArray($notifiable)
    {
        return [
            'badge' => 1,
            'title' => __('claims.notifications.status_change', [], $notifiable->locale),
            'message' => $this->message,
        ];
    }
}
