<?php

namespace App\Models;

use Backpack\CRUD\CrudTrait;
use Illuminate\Database\Eloquent\Model;

class Review extends Model
{
    use CrudTrait;

    protected $fillable = [
        'text',
        'apartment',
        'object_id',
        'answer',
        'is_viewed',
        'user_id',
        'updated_at_answer',
    ];

    public function setNotViewed()
    {
        $this->is_viewed = false;
        $this->save();
    }

    public function getStatusAttribute() {
        if(empty($this->lastAnswer()->first()['is_concierge']) && $this->is_viewed) {
            return 1;
        } else if(!empty($this->lastAnswer()->first()['is_concierge'])) {
            return 2;
        }

        return 0;
    }

    public static function statuses() {
        return [
            0 => 'not_viewed',
            1 => 'awaiting_response',
            2 => 'processed',
        ];
    }

    public function getStatusNameHtml() {
        $status = $this->status;
        return $status !== NULL ? "<span class='status-name-value'>" . trans('reviews.statuses.' . self::statuses()[$status]) . "</span>" : "";
    }

    public function getStatusName() {
        $status = $this->attributes['status'];
        return $status !== NULL ? "<span class='status-name-value'>" . trans('reviews.statuses.' . self::statuses()[$status]) . "</span>" : "";
    }

    public function answers() {
        return $this->hasMany('App\Models\Answer', 'review_id', 'id')
            ->orderBy('created_at');
    }

    public function lastAnswer() {
        return $this->hasMany('App\Models\Answer', 'review_id', 'id')
            ->latest();
    }

    public function lastConciergeAnswer() {
        $last_answer = $this
            ->hasOne('App\Models\Answer', 'review_id', 'id')
            ->where('is_concierge', '=', 1)
            ->latest()->first();
        return $last_answer['text'];
    }
}
