<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Backpack\CRUD\CrudTrait;
use Illuminate\Database\Eloquent\Builder;

class QuizTemplate extends Model
{
    use CrudTrait;
    protected $table = 'quizzes';
    protected $fillable = ['title','question','free_answer', 'multiple', 'allow_view_results', 'is_template', 'active', 'tags', 'category_id', 'object_id'];

    // relations
    public function answers()
    {
        return $this->hasMany('App\Models\QuizAnswer', 'quiz_id', 'id');
    }

    protected static function boot() {
        parent::boot();

        static::addGlobalScope('template', function (Builder $builder) {
            $builder->where('is_template', '=', 1);
        });

    }

    // relations
    public function category()
    {
        return $this->belongsTo('App\Models\Category', 'category_id');
    }
}
