<?php

namespace App\Models\PermissionManager;

use Backpack\PermissionManager\app\Models\Permission as BackpackPermission;

/**
 * Class Permission
 *
 * @property int    $id
 * @property string $name
 * @property string $weight
 * @property string $created_at
 * @property string $updated_at
 *
 * @property \Illuminate\Database\Eloquent\Collection $roles
 * @property \Illuminate\Database\Eloquent\Collection $users
 *
 * @package App\Models\PermissionManager
 */
class Permission extends BackpackPermission
{

    /**
     * Все модели: Полный доступ
     */
    const FULL_ACCESS = 'полный доступ';
    const FULL_ACCESS_WEIGHT = 500;
    const FULL_ACCESS_GROUP = PermissionGroup::FULL_ACCESS;

    /**
     * Пользователь: Создание
     */
    const USER_CREATE_ACCESS = 'Пользователь: Создание';
    const USER_CREATE_ACCESS_WEIGHT = 100;
    const USER_CREATE_ACCESS_GROUP = PermissionGroup::USERS;

    /**
     * Пользователь: Просмотр (полный)
     */
    const USER_VIEW_FULL_ACCESS = 'Пользователь: Просмотр (полный)';
    const USER_VIEW_FULL_ACCESS_WEIGHT = 40;
    const USER_VIEW_FULL_ACCESS_GROUP = PermissionGroup::USERS;

    /**
     * Пользователь: Просмотр (ограниченный)
     */
    const USER_VIEW_LIMITED_ACCESS = 'Пользователь: Просмотр (ограниченный)';
    const USER_VIEW_LIMITED_ACCESS_WEIGHT = 30;
    const USER_VIEW_LIMITED_ACCESS_GROUP = PermissionGroup::USERS;

    /**
     * Пользователь: Изменение (расширенный)
     */
    const USER_EDIT_FULL_ACCESS = 'Пользователь: Изменение (расширенный)';
    const USER_EDIT_FULL_ACCESS_WEIGHT = 50;
    const USER_EDIT_FULL_ACCESS_GROUP = PermissionGroup::USERS;

    /**
     * Пользователь: Изменение
     */
    const USER_EDIT_ACCESS = 'Пользователь: Изменение';
    const USER_EDIT_ACCESS_WEIGHT = 40;
    const USER_EDIT_ACCESS_GROUP = PermissionGroup::USERS;

    /**
     * Пользователь: Удаление
     */
    const USER_DELETE_ACCESS = 'Пользователь: Удаление';
    const USER_DELETE_ACCESS_WEIGHT = 100;
    const USER_DELETE_ACCESS_GROUP = PermissionGroup::USERS;

    /**
     * Права пользователя: Просмотр списка разрешений
     */
    const PERMISSIONS_VIEW_ACCESS = 'Права пользователя: Просмотр списка разрешений';
    const PERMISSIONS_VIEW_ACCESS_WEIGHT = 0;
    const PERMISSIONS_VIEW_ACCESS_GROUP = PermissionGroup::PERMISSIONS;

    /**
     * Роли: Создание
     */
    const ROLES_CREATE_ACCESS = 'Роли: Создание';
    const ROLES_CREATE_ACCESS_WEIGHT = 5;
    const ROLES_CREATE_ACCESS_GROUP = PermissionGroup::ROLES;

    /**
     * Роли: Просмотр
     */
    const ROLES_VIEW_ACCESS = 'Роли: Просмотр';
    const ROLES_VIEW_ACCESS_WEIGHT = 0;
    const ROLES_VIEW_ACCESS_GROUP = PermissionGroup::ROLES;

    /**
     * Роли: Изменение
     */
    const ROLES_EDIT_ACCESS = 'Роли: Изменение';
    const ROLES_EDIT_ACCESS_WEIGHT = 2;
    const ROLES_EDIT_ACCESS_GROUP = PermissionGroup::ROLES;

    /**
     * Роли: Удаление
     */
    const ROLES_DELETE_ACCESS = 'Роли: Удаление';
    const ROLES_DELETE_ACCESS_WEIGHT = 5;
    const ROLES_DELETE_ACCESS_GROUP = PermissionGroup::ROLES;


    /**
     * Квартиры: Создание
     */
    const APARTMENTS_CREATE_ACCESS = 'Квартиры: Создание';
    const APARTMENTS_CREATE_ACCESS_WEIGHT = 8;
    const APARTMENTS_CREATE_ACCESS_GROUP = PermissionGroup::APARTMENTS;

    /**
     * Квартиры: Просмотр (ограниченный)
     */
    const APARTMENTS_VIEW_LIMITED_ACCESS = 'Квартиры: Просмотр (ограниченный)';
    const APARTMENTS_VIEW_LIMITED_ACCESS_WEIGHT = 0;
    const APARTMENTS_VIEW_LIMITED_ACCESS_GROUP = PermissionGroup::APARTMENTS;

    /**
     * Квартиры: Просмотр (полный)
     */
    const APARTMENTS_VIEW_FULL_ACCESS = 'Квартиры: Просмотр (полный)';
    const APARTMENTS_VIEW_FULL_ACCESS_WEIGHT = 2;
    const APARTMENTS_VIEW_FULL_ACCESS_GROUP = PermissionGroup::APARTMENTS;

    /**
     * Квартиры: Изменение
     */
    const APARTMENTS_EDIT_ACCESS = 'Квартиры: Изменение';
    const APARTMENTS_EDIT_ACCESS_WEIGHT = 4;
    const APARTMENTS_EDIT_ACCESS_GROUP = PermissionGroup::APARTMENTS;


    /**
     * Камеры: Создание
     */
    const CAMERAS_CREATE_ACCESS = 'Камеры: Создание';
    const CAMERAS_CREATE_ACCESS_WEIGHT = 7;
    const CAMERAS_CREATE_ACCESS_GROUP = PermissionGroup::CAMERAS;

    /**
     * Камеры: Список (ограниченный просмотр)
     */
    const CAMERAS_VIEW_LIMITED_ACCESS = 'Камеры: Список (ограниченный просмотр)';
    const CAMERAS_VIEW_LIMITED_ACCESS_WEIGHT = 0;
    const CAMERAS_VIEW_LIMITED_ACCESS_GROUP = PermissionGroup::CAMERAS;

    /**
     * Камеры: Изменение
     */
    const CAMERAS_EDIT_ACCESS = 'Камеры: Изменение';
    const CAMERAS_EDIT_ACCESS_WEIGHT = 4;
    const CAMERAS_EDIT_ACCESS_GROUP = PermissionGroup::CAMERAS;

    /**
     * Камеры: Удаление
     */
    const CAMERAS_DELETE_ACCESS = 'Камеры: Удаление';
    const CAMERAS_DELETE_ACCESS_WEIGHT = 7;
    const CAMERAS_DELETE_ACCESS_GROUP = PermissionGroup::CAMERAS;


    /**
     * Вызывные панели: Создание
     */
    const CALLING_PANELS_CREATE_ACCESS = 'Вызывные панели: Создание';
    const CALLING_PANELS_CREATE_ACCESS_WEIGHT = 7;
    const CALLING_PANELS_CREATE_ACCESS_GROUP = PermissionGroup::CALLING_PANELS;

    /**
     * Вызывные панели: Список (ограниченный просмотр)
     */
    const CALLING_PANELS_VIEW_LIMITED_ACCESS = 'Вызывные панели: Список (ограниченный просмотр)';
    const CALLING_PANELS_VIEW_LIMITED_ACCESS_WEIGHT = 0;
    const CALLING_PANELS_VIEW_LIMITED_ACCESS_GROUP = PermissionGroup::CALLING_PANELS;

    /**
     * Вызывные панели: Изменение
     */
    const CALLING_PANELS_EDIT_ACCESS = 'Вызывные панели: Изменение';
    const CALLING_PANELS_EDIT_ACCESS_WEIGHT = 4;
    const CALLING_PANELS_EDIT_ACCESS_GROUP = PermissionGroup::CALLING_PANELS;

    /**
     * Вызывные панели: Удаление
     */
    const CALLING_PANELS_DELETE_ACCESS = 'Вызывные панели: Удаление';
    const CALLING_PANELS_DELETE_ACCESS_WEIGHT = 7;
    const CALLING_PANELS_DELETE_ACCESS_GROUP = PermissionGroup::CALLING_PANELS;


    /**
     * Доска объявлений: Полный доступ
     */
    const ANNOUNCEMENT_FULL_ACCESS = 'Доска объявлений: Полный доступ';
    const ANNOUNCEMENT_FULL_ACCESS_WEIGHT = 4;
    const ANNOUNCEMENT_FULL_ACCESS_GROUP = PermissionGroup::ANNOUNCEMENTS;


    /**
     * Отзывы: Полный доступ
     */
    const REVIEWS_FULL_ACCESS = 'Отзывы: Полный доступ';
    const REVIEWS_FULL_ACCESS_WEIGHT = 4;
    const REVIEWS_FULL_ACCESS_GROUP = PermissionGroup::REVIEWS;

    /**
     * Уведомления: Полный доступ
     */
    const NOTIFICATIONS_FULL_ACCESS = 'Уведомления: Полный доступ';
    const NOTIFICATIONS_FULL_ACCESS_WEIGHT = 4;
    const NOTIFICATIONS_FULL_ACCESS_GROUP = PermissionGroup::NOTIFICATIONS;


    /**
     * Опросы: Полный доступ
     */
    const QUIZES_FULL_ACCESS = 'Опросы: Полный доступ';
    const QUIZES_FULL_ACCESS_WEIGHT = 4;
    const QUIZES_FULL_ACCESS_GROUP = PermissionGroup::QUIZES;


    /**
     * Шаблоны: Шаблоны опросов
     */
    const QUIZ_TEMPLATES_ACCESS = 'Шаблоны: Шаблоны опросов';
    const QUIZ_TEMPLATES_ACCESS_WEIGHT = 1;
    const QUIZ_TEMPLATES_ACCESS_GROUP = PermissionGroup::QUIZ_TEMPLATES;

    /**
     * Шаблоны: Шаблоны сообщений
     */
    const MESSAGE_TEMPLATES_ACCESS = 'Шаблоны: Шаблоны сообщений';
    const MESSAGE_TEMPLATES_ACCESS_WEIGHT = 1;
    const MESSAGE_TEMPLATES_ACCESS_GROUP = PermissionGroup::QUIZ_TEMPLATES;


    /**
     * Типы заявок: Полный доступ
     */
    const CLAIM_TYPES_FULL_ACCESS = 'Типы заявок: Полный доступ';
    const CLAIM_TYPES_FULL_ACCESS_WEIGHT = 2;
    const CLAIM_TYPES_FULL_ACCESS_GROUP = PermissionGroup::CLAIM_TYPES;

    /**
     * Типы заявок: Просмотр
     */
    const CLAIM_TYPES_VIEW_ACCESS = 'Типы заявок: Просмотр';
    const CLAIM_TYPES_VIEW_ACCESS_WEIGHT = 0;
    const CLAIM_TYPES_VIEW_ACCESS_GROUP = PermissionGroup::CLAIM_TYPES;


    /**
     * Заявки: Все заявки
     */
    const CLAIMS_ALL_ACCESS = 'Заявки: Все заявки';
    const CLAIMS_ALL_ACCESS_WEIGHT = 4;
    const CLAIMS_ALL_ACCESS_GROUP = PermissionGroup::CLAIMS;

    /**
     * Заявки: Заявки по типу
     */
    const CLAIMS_BY_TYPE_ACCESS = 'Заявки: Заявки по типу';
    const CLAIMS_BY_TYPE_ACCESS_WEIGHT = 2;
    const CLAIMS_BY_TYPE_ACCESS_GROUP = PermissionGroup::CLAIMS;


    /**
     * Авторизованные пользователи: Полный доступ
     */
    const AUTHORIZED_USERS_FULL_ACCESS = 'Авторизованные пользователи: Полный доступ';
    const AUTHORIZED_USERS_FULL_ACCESS_WEIGHT = 2;
    const AUTHORIZED_USERS_FULL_ACCESS_GROUP = PermissionGroup::AUTHORIZED_USERS;

    /**
     * Авторизованные пользователи: Частичный доступ
     */
    const AUTHORIZED_USERS_LIMITED_ACCESS = 'Авторизованные пользователи: Частичный доступ';
    const AUTHORIZED_USERS_LIMITED_ACCESS_WEIGHT = 0;
    const AUTHORIZED_USERS_LIMITED_ACCESS_GROUP = PermissionGroup::AUTHORIZED_USERS;


    /**
     * Настройки: Просмотр
     */
    const SETTINGS_VIEW_ACCESS = 'Настройки: Просмотр';
    const SETTINGS_VIEW_ACCESS_WEIGHT = 5;
    const SETTINGS_VIEW_ACCESS_GROUP = PermissionGroup::SETTINGS;

    /**
     * Настройки: Редактирование
     */
    const SETTINGS_EDIT_ACCESS = 'Настройки: Редактирование';
    const SETTINGS_EDIT_ACCESS_WEIGHT = 10;
    const SETTINGS_EDIT_ACCESS_GROUP = PermissionGroup::SETTINGS;


    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'name',
        'weight',
        'group_id',
        'updated_at',
        'created_at',
    ];

    /**
     * @param array|null $permissions
     * @param array|null $roles
     *
     * @return int
     */
    public static function getPermissionsWeight($permissions = null, $roles = null)
    {
        $permissions = collect($permissions)->map(function ($permissionId) {
            return Permission::find($permissionId);
        });

        if (!is_null($roles)) {
            collect($roles)->each(function($roleId) use (&$permissions) {
                $permissions = $permissions->concat(Role::find($roleId)->permissions);
            });
        }

        return (int)$permissions->unique('id')->sum('weight');
    }

    /**
     * @return array|\Illuminate\Contracts\Translation\Translator|null|string
     */
    public function getTranslatedNameAttribute()
    {
        return trans('permissions.' . $this->name);
    }

    public function group()
    {
        $this->hasOne('App\Models\PermissionManager\PermissionGroup');
    }
}
