<?php

namespace App\Models;

use Backpack\CRUD\CrudTrait;
use Illuminate\Database\Eloquent\Model;

class Notice extends Model {

    use CrudTrait;

    protected $table = 'notice';

    protected $hidden = ['created_at', 'updated_at', 'apartment', 'push_sent'];

    protected $fillable = [
        'object_id',
        'theme',
        'text',
        'actual_from_date',
        'actual_to_date',
        'apartment',
    ];

    public function viewed() {
        return $this->hasMany(NoticeViewed::class);
    }

    public function isViewedAtLeastOne() {
        return (bool) $this->viewed()->count();
    }

    public function getWhom()
    {
        return __('notice.form_fields.apartment')." №".$this->attributes['apartment'];
    }

    /**
     * Является ли уведомление действующим
     *
     * @return boolean
     */
    public function isActive()
    {
        $date = date('Y-m-d');

        if ($this->actual_from_date <= $date && $date <= $this->actual_to_date) {
            return true;
        }

        return false;
    }

    /**
     * Будет ли уведомление действовать в будущем
     *
     * @return boolean
     */
    public function isWillActive()
    {
        $date = date('Y-m-d');

        if ($this->actual_from_date > $date) {
            return true;
        }

        return false;
    }
}