<?php

namespace App\Models;

use Backpack\CRUD\CrudTrait;
use Illuminate\Database\Eloquent\Model;

class MessageTemplate extends Model {

    use CrudTrait;

    protected $table = 'message_templates';

    public $timestamps = FALSE;

    protected $fillable = ['text', 'theme', 'category_id', 'tags'];

    // relations
    public function category()
    {
        return $this->belongsTo('App\Models\Category', 'category_id');
    }

}
