<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Notifications\Notifiable;

class Device extends Model
{
    use Notifiable;

    /**
     * Indicates if the IDs are auto-incrementing.
     *
     * @var bool
     */
    public $incrementing = false;

    protected $visible = ['id', 'locale', 'push_token', 'sip_number', 'is_ios'];

    protected $fillable = ['locale', 'push_token', 'sip_number', 'is_ios'];

    public function routeNotificationForGcm()
    {
        return $this->push_token;
    }

    public function sip_number()
    {
        return $this->hasOne(ApartmentSipNumber::class, 'id', 'sip_number_id');
    }

    public function apartment()
    {
        return $this->belongsTo(Apartment::class);
    }
}
