<?php

namespace App\Models;

use Intervention\Image\Facades\Image;
use Storage;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Log;
use App\Models\Claim;

class ClaimImage extends Model
{
    protected $table = 'claim_images';

    protected $appends = ['image_url'];
    protected $hidden = ['id', 'name', 'created_at', 'updated_at', 'claim_id', 'thumb'];
    protected $thumb_prefix = 'thumb';

    /*
     * заполняет поля информацией о файле
     */
    public function addImage($image, $claim_id, $thumb = [30, 30]) {
        $image_name = $image->store('', 'public');

        $image_resize = Image::make($image->getRealPath());
        $image_resize->resize(30, 30);
        $image_resize->save((storage_path('app/public') . '/' . $this->thumb_prefix . '_' . $image_name));

        if($image_name) {
            $info = pathinfo(storage_path().$image_name);
            $this->name = $image_name;
            $this->thumb = $this->thumb_prefix . '_' .$image_name;
            $this->claim_id = $claim_id;
        }
    }

    public function getImageUrlAttribute() {
        $file =  $this->attributes['name'] ?  $this->attributes['name'] : null;
        return $file ? '/api/media/images/' . $file : null;
    }

    public function getImageThumbUrlAttribute() {
        $file =  $this->attributes['thumb'] ?  $this->attributes['thumb'] : null;
        return $file ? '/api/media/images/' . $file : null;
    }

    public function claim() {
        return $this->belongsTo('App\Models\Claim','claim_id');
    }

}
