<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Backpack\CRUD\CrudTrait;

/**
 * Class CallingPanel
 *
 * @property int $id
 * @property string $name
 * @property string $sip_number
 * @property string $rtsp_link
 * @property string $login
 * @property string $password
 * @property string $ip_address
 * @property int $port
 * @property string $dtmf_1
 * @property string $dtmf_2
 * @property string $created_at
 * @property string $updated_at
 *
 * @package App\Models
 */
class CallingPanel extends Model
{
    use CrudTrait;

    const RTSP_LINK_TYPE_FULL = 'full';
    const RTSP_LINK_TYPE_PARAMETERS = 'parameters';

     /*
    |--------------------------------------------------------------------------
    | GLOBAL VARIABLES
    |--------------------------------------------------------------------------
    */

    protected $table = 'calling_panels';
    protected $primaryKey = 'id';
    // public $timestamps = false;
    // protected $guarded = ['id'];
    protected $fillable = [
        'name',
        'sip_number',
        'rtsp_link',
        'login',
        'password',
        'ip_address',
        'port',
        'dtmf_1',
        'dtmf_2',
        'object_id',
        'is_callable',
    ];
    // protected $hidden = [];
    // protected $dates = [];

    /*
    |--------------------------------------------------------------------------
    | FUNCTIONS
    |--------------------------------------------------------------------------
    */

    /*
    |--------------------------------------------------------------------------
    | RELATIONS
    |--------------------------------------------------------------------------
    */
    public function apartments()
    {
        return $this->belongsToMany('App\Models\Apartment');
    }

    /*
    |--------------------------------------------------------------------------
    | SCOPES
    |--------------------------------------------------------------------------
    */

    /*
    |--------------------------------------------------------------------------
    | ACCESORS
    |--------------------------------------------------------------------------
    */
    /**
     * @return string
     */
    public function getRtspLinkTypeAttribute()
    {
        return !$this->login ? self::RTSP_LINK_TYPE_FULL : self::RTSP_LINK_TYPE_PARAMETERS;
    }

    /**
     * @return bool
     */
    public function getHasSecondRelayAttribute()
    {
        return !empty($this->dtmf_2);
    }

    /*
    |--------------------------------------------------------------------------
    | MUTATORS
    |--------------------------------------------------------------------------
    */

    public function getRtsp(){
        if($this->rtsp_link){
            $rtsp = urldecode($this->rtsp_link);
        } else {
            $rtsp= 'rtsp://' . urldecode($this->login) . ':' . urldecode($this->password)
                . '@' . urldecode($this->ip_address) . ':' . urldecode($this->port);
        }
        return $rtsp;
    }
}
