<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Backpack\CRUD\CrudTrait;

class ApartmentSipNumber extends Model
{
    use CrudTrait;
    protected $table = 'apartment_sip_numbers';
    protected $fillable = [
        'apartment_id',
        'sip_number',
        'sip_password',
        'token'
    ];

    protected $device_token;

    public $incrementing = false;

    public function device_token()
    {
        return $this->hasOne(Device::class, 'sip_number_id', 'id')->pluck('id');
    }

    public function getTokenAttribute()
    {
        return $this->device_token();
    }

    /**
     * Get sip numbers models with object id's
     *
     * @return \Illuminate\Support\Collection
     */
    public static function getSipNumbersWithObjectId($not_in = null)
    {
        $query = self::getSipNumbersWithObjectIdQuery();

        if (!is_null($not_in)) {
            $query
                ->whereNotIn('apartment_sip_numbers.id', $not_in);
        }

        return $query->get();
    }

    /**
     * Get only one sip number from DB with object_id
     *
     * @param $sip_number
     * @return mixed
     */
    public static function getSipNumberWithObjectId($sip_number)
    {
        $query = self::getSipNumbersWithObjectIdQuery();

        $query
            ->where('sip_number', $sip_number);

        return $query->first();
    }

    /**
     * Query for get sip numbers models with object_id
     *
     * @return ApartmentSipNumber
     */
    protected static function getSipNumbersWithObjectIdQuery() {
        return ApartmentSipNumber
            ::join('apartments', 'apartments.id', '=', 'apartment_sip_numbers.apartment_id')
            ->where('object_id', config('app.object.id'))
            // Cut off unnecessary columns
            ->select('apartments.object_id', 'apartment_sip_numbers.*');
    }
}
