<?php

namespace App\Http\Responses;

use Illuminate\Http\JsonResponse;

/**
 * Class ErrorJsonResponse
 *
 * @package App\Http\Responses
 */
class ErrorJsonResponse extends JsonResponse
{


    /**
     * ErrorJsonResponse constructor.
     *
     * @param string $message
     * @param int $status
     * @param array $headers
     * @param int $options
     * @param array $data
     */
    public function __construct(
        string $message,
        int $status,
        array $headers = [],
        int $options = 0,
        array $data = []
    )
    {
        $data = array_merge_recursive($data, [
            'error' => [
                'code' => $status,
                'message' => $message,
            ],
        ]);

        $this->encodingOptions = $options;

        parent::__construct($data, $status, $headers);
    }
}
