<?php

namespace App\Http\Requests;

use App\Rules\NotGreaterWeightPermissions;
use Backpack\PermissionManager\app\Http\Requests\UserStoreCrudRequest as BackpackUserStoreCrudRequest;

/**
 * Class UserStoreCrudRequest
 *
 * @package Backpack\NewsCRUD\app\Http\Requests
 */
class UserStoreCrudRequest extends BackpackUserStoreCrudRequest
{
    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        $backpackRules = [
            'email'    => 'required|unique:'.config('laravel-permission.table_names.users', 'users').',email|email',
            'name'     => 'required',
            'password' => 'required|confirmed',
        ];

        $backpackRules['permissions'] = new NotGreaterWeightPermissions();
        $backpackRules['roles'] = new NotGreaterWeightPermissions();

        return $backpackRules;
    }
    /**
     * @return array
     */
    public function attributes()
    {
        $attributes = [
            'name' => __("user.crud_fields.name"),
            'email' => __("user.crud_fields.email"),
            'password' => __("user.crud_fields.password"),

        ];

        return $attributes;
    }

}
