<?php

namespace App\Http\Requests;

use App\Http\Requests\Request;
use App\Http\Controllers\Admin\CameraCrudController;

class QuizTemplateRequest extends \Backpack\CRUD\app\Http\Requests\CrudRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        // only allow updates if the user is logged in
        return \Auth::check();
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'title' => 'required|max:100',
            'category_id' => 'required',
            'question' => 'required|max:1000',
            'answers' => 'required_if:free_answer,0'
        ];
    }

    /**
     * Get the validation messages that apply to the request.
     *
     * @return array
     */
    public function messages()
    {
        return [
            //
        ];
    }
}
