<?php

namespace App\Http\Requests;

use App\Http\Requests\Request;
use App\Http\Controllers\Admin\CameraCrudController;

class QuizRequest extends \Backpack\CRUD\app\Http\Requests\CrudRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        // only allow updates if the user is logged in
        return \Auth::check();
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'title' => 'required|max:100',
            'question' => 'required|max:1000',
            'start_at' => 'required',
            'end_at' => 'required',
            'destinations' => 'required_if:is_all_house,0',
            'answers' => 'required_if:free_answer,0'
        ];
    }

    /**
     * Get the validation messages that apply to the request.
     *
     * @return array
     */
    public function messages()
    {
        return [
            //
        ];
    }
}
