<?php

namespace App\Http\Requests;


class BuildingRequest extends \Backpack\CRUD\app\Http\Requests\CrudRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        // only allow updates if the user is logged in
        return \Auth::check();
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'name' => 'required|string|min:3|max:100',
            'address' => 'required|string|min:3|max:255',
            'sip_server_address' => 'required|max:255',
            'sip_server_port' => 'nullable|numeric',
            'concierge_sip_number' => 'required|numeric',
        ];
    }

    public function attributes()
    {
        $attributes = [
            'name' => __("objects.crud_fields.name"),
            'address' => __("objects.crud_fields.address"),
            'sip_server_address' => __("objects.crud_fields.sip_server_address"),
            'sip_server_port' => __("objects.crud_fields.sip_server_port"),
            'concierge_sip_number' => __("objects.crud_fields.concierge_sip_number"),
        ];

        return $attributes;
    }
}
