<?php

namespace App\Http\Middleware;

use App;
use Closure;
use Config;
use Illuminate\Support\Facades\Auth;

class LocalisationMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
        $user = Auth::user();

        $localeFromHeader = $request->header('accept-language');
        if (!empty($localeFromHeader)) {
            if (in_array($localeFromHeader, Config::get('app.locales'))) {
                $locale = $localeFromHeader;

                if (!empty($user)) {
                    $user->device()->update(['locale' => $locale]);
                }
            }
        }

        if (empty($locale) && !empty($user)) {
            $locale = $user->device()->first()->locale;
        }

        if (empty($locale)) {
            $locale = Config::get('app.fallback_locale');
        }

        App::setLocale($locale);

        return $next($request);
    }
}
