<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\JsonResponse;

/**
 * Class BuildApiResponse
 *
 * @package App\Http\Middleware
 */
class BuildApiResponse
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
        /** @var \Symfony\Component\HttpFoundation\Response $response */
        $response = $next($request);

        if (
            $response instanceof JsonResponse
            &&
            (
                $response->isClientError()
                ||
                $response->isServerError()
            )
        ) {
            $errorData = $response->getOriginalContent();

            if (!isset($errorData['error'])) {
                $errorData = ['error' => $errorData];
            }

            if (!isset($errorData['error']['message'])) {
                if (is_string($errorData['error'])) {
                    $errorData['error'] = ['message' => $errorData['error']];
                }
            }

            $translatedMessage = trans('validation.' . $errorData['error']['message']);
            if (!starts_with($translatedMessage, 'validation.')) {
                $errorData['error']['message'] = $translatedMessage;
            }

            if (empty($errorData['error']['code'])) {
                $errorData['error'] = array_merge(
                    ['code' => $response->getStatusCode()],
                    $errorData['error']
                );
            }

            $response->setData($errorData);
        }

        return $response;
    }
}
