<?php
namespace App\Http\Controllers\Mock;

use Faker\Factory as FakerFactory;
use Illuminate\Http\Request;
use Illuminate\Validation\Rule;
use Illuminate\Validation\ValidationException;

/**
 * Class ReCallController
 *
 * @package App\Http\Controllers\Mock
 */
class ReCallController extends BaseMockController
{

    /**
     * @param \Illuminate\Http\Request $request
     *
     * @return \Illuminate\Contracts\Routing\ResponseFactory|\Symfony\Component\HttpFoundation\Response
     */
    public function recall(Request $request)
    {
        try {
            $this->validate($request, [
                'text' => 'required|filled',
            ]);
        } catch (ValidationException $validationException) {
            $errorMessages = [];
            $failedValidationRules = $validationException->validator->failed();

            if (isset($failedValidationRules['text'])) {
                $errorMessages['text'] = 'Поле Текст содержит недопустимое значение.';
                if (isset($failedValidationRules['text']['Required'])) {
                    $errorMessages['text'] = 'Поле Текст обязательно для заполнения.';
                }
            }

            return $this->badRequestJsonResponse($errorMessages);
        }

        return $this->emptyJsonResponse();
    }

    /**
     * @param \Illuminate\Http\Request $request
     *
     * @return \Illuminate\Contracts\Routing\ResponseFactory|\Symfony\Component\HttpFoundation\Response
     */
    public function logout(Request $request)
    {
        return $this->emptyJsonResponse();
    }
}
