<?php
namespace App\Http\Controllers\Mock;

use Faker\Factory as FakerFactory;
use Illuminate\Http\Request;
use Illuminate\Validation\ValidationException;

/**
 * Class QuizController
 *
 * @package App\Http\Controllers\Mock
 */
class QuizController extends BaseMockController
{

    /**
     * @param \Illuminate\Http\Request $request
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function getUserQuizzes(Request $request)
    {
        $userQuizzes = [];

        $faker = FakerFactory::create();
        if ($faker->boolean(50)) {
            $userQuizzesCount = $faker->numberBetween(1, 5);
            for ($i = 1; $i <= $userQuizzesCount; ++$i) {
                $is_free_answer = $faker->boolean(50);
                $is_multiple = $faker->boolean(50);

                $quizAnswers = [];
                $quizSelectedAnswers = [];

                $quizAnswersCount = $faker->numberBetween(1, 5);
                for ($j = 1; $j <= $quizAnswersCount; ++$j) {
                    $answerId = $faker->numberBetween(1, 1000);
                    $quizAnswers[] = [
                        'id' => $answerId,
                        'text' => $faker->sentence(),
                    ];
                }

                if ($faker->boolean(50)) {
                    $quizAnswersIds = array_column($quizAnswers, 'id');
                    $quizSelectedAnswersCount = $is_multiple ? $faker->numberBetween(1, count($quizAnswersIds)) : 1;
                    $arrayRandKeys = array_rand($quizAnswersIds, $quizSelectedAnswersCount);
                    if (!is_array($arrayRandKeys)) {
                        $arrayRandKeys = [$arrayRandKeys];
                    }

                    $quizSelectedAnswers = array_values(array_intersect_key($quizAnswersIds, array_flip($arrayRandKeys)));
                }

                $userQuizzes[] = [
                    'id' => $faker->numberBetween(1, 1000),
                    'question' => $faker->sentence(),
                    'answers' => $quizAnswers,
                    'selected_answers' => $quizSelectedAnswers,
                    'is_free_answer' => $is_free_answer,
                    'free_answer_title' => $is_free_answer ? $faker->sentence() : '',
                    'is_multiple' => $is_multiple,
                    'allow_view_results' => $faker->boolean(50),
                    'start_date' => $faker->date() . ' ' . $faker->time(),
                    'actual_to_date' => $faker->date() . ' ' . $faker->time(),
                    'is_viewed' => $faker->boolean(50),
                ];
            }
        }

        return response()->json([
            'quizzes' => $userQuizzes,
        ]);
    }

    /**
     * @param \Illuminate\Http\Request $request
     *
     * @return \Illuminate\Contracts\Routing\ResponseFactory|\Symfony\Component\HttpFoundation\Response
     */
    public function markQuizAsRead(Request $request)
    {
        return $this->emptyJsonResponse();
    }

    /**
     * @param \Illuminate\Http\Request $request
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function getQuizResults(Request $request)
    {
        $faker = FakerFactory::create();

        $quizAnswers = [];

        $quizAnswersCount = $faker->numberBetween(1, 5);
        for ($j = 1; $j <= $quizAnswersCount; ++$j) {
            $quizAnswers[] = [
                'text' => $faker->sentence(),
                'answers_count' => $faker->numberBetween(1, 50),
            ];
        }

        $quizResults = [
            'id' => $faker->numberBetween(1, 1000),
            'question' => $faker->sentence(),
            'answers' => $quizAnswers,
            'free_answers_count' => $faker->numberBetween(1, 50),
        ];

        return response()->json([
            'results' => $quizResults,
        ]);
    }

    /**
     * @param \Illuminate\Http\Request $request
     *
     * @return \Illuminate\Contracts\Routing\ResponseFactory|\Symfony\Component\HttpFoundation\Response
     */
    public function setQuizAnswers(Request $request)
    {
        try {
            $this->validate($request, [
                'answers' => 'required|filled|array',
            ]);
        } catch (ValidationException $validationException) {
            $errorMessages = [];
            $failedValidationRules = $validationException->validator->failed();

            if (isset($failedValidationRules['answers'])) {
                $errorMessages['answers'] = 'Поле Ответы содержит недопустимое значение.';
                if (isset($failedValidationRules['answers']['Required'])) {
                    $errorMessages['answers'] = 'Поле Ответы обязательно для заполнения.';
                }
                if (isset($failedValidationRules['answers']['Array'])) {
                    $errorMessages['answers'] = 'Поле Ответы должно содержать массив ответов.';
                }
            }

            return $this->badRequestJsonResponse($errorMessages);
        }

        return $this->emptyJsonResponse();
    }
}
