<?php
namespace App\Http\Controllers\Mock;

use Faker\Factory as FakerFactory;
use Illuminate\Http\Request;
use Illuminate\Validation\Rule;
use Illuminate\Validation\ValidationException;

/**
 * Class LoginController
 *
 * @package App\Http\Controllers\Mock
 */
class LoginController extends BaseMockController
{

    /**
     * @param \Illuminate\Http\Request $request
     *
     * @return \Illuminate\Contracts\Routing\ResponseFactory|\Symfony\Component\HttpFoundation\Response
     */
    public function login(Request $request)
    {
        try {
            $this->validate($request, [
                'apartment_number' => 'required|numeric',
                'activation_code' => 'required',
            ]);
        } catch (ValidationException $validationException) {
            $errorMessages = [];
            $failedValidationRules = $validationException->validator->failed();

            if (isset($failedValidationRules['apartment_number'])) {
                $errorMessages['apartment_number'] = 'Поле Номер квартиры содержит недопустимое значение.';
                if (isset($failedValidationRules['apartment_number']['Required'])) {
                    $errorMessages['apartment_number'] = 'Поле Номер квартиры обязательно для заполнения.';
                }
            }

            if (isset($failedValidationRules['activation_code'])) {
                $errorMessages['activation_code'] = 'Поле Код активации содержит недопустимое значение.';
                if (isset($failedValidationRules['activation_code']['Required'])) {
                    $errorMessages['activation_code'] = 'Поле Код активации обязательно для заполнения.';
                }
            }

            return $this->badRequestJsonResponse($errorMessages);
        }

        $faker = FakerFactory::create();

        return $this->jsonResponse([
            'id' => $faker->numberBetween(1, 10000),
            'phone' => $faker->e164PhoneNumber,
            'email' => $faker->email,
            'name' => $faker->name,
            'created_at' => $faker->date() . ' ' . $faker->time(),
            'updated_at' => $faker->date() . ' ' . $faker->time(),
            'api_token' => substr($faker->sha256, 0, 60),
        ]);
    }

    /**
     * @param \Illuminate\Http\Request $request
     *
     * @return \Illuminate\Contracts\Routing\ResponseFactory|\Symfony\Component\HttpFoundation\Response
     */
    public function logout(Request $request)
    {
        return $this->emptyJsonResponse();
    }
}
