<?php
namespace App\Http\Controllers\Mock;

use Faker\Factory as FakerFactory;
use Illuminate\Http\Request;
use Illuminate\Validation\Rule;
use Illuminate\Validation\ValidationException;

/**
 * Class LocaleController
 *
 * @package App\Http\Controllers\Mock
 */
class LocaleController extends BaseMockController
{
    const AVAILABLE_LOCALES = ['ru', 'en'];

    /**
     * @param \Illuminate\Http\Request $request
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function getLocale(Request $request)
    {
        return response()->json([
            'lang' => FakerFactory::create()->randomElement(self::AVAILABLE_LOCALES),
        ]);
    }

    /**
     * @param \Illuminate\Http\Request $request
     *
     * @return \Illuminate\Contracts\Routing\ResponseFactory|\Symfony\Component\HttpFoundation\Response
     */
    public function setLocale(Request $request)
    {
        try {
            $this->validate($request, [
                'lang' => ['required', Rule::in(self::AVAILABLE_LOCALES)],
            ]);
        } catch (ValidationException $validationException) {
            $failedValidationRules = $validationException->validator->failed();

            $errorMessages = ['lang' => 'Поле Язык содержит недопустимое значение.'];
            if (isset($failedValidationRules['lang']['Required'])) {
                $errorMessages['lang'] = 'Поле Язык обязательно для заполнения.';
            }

            return $this->badRequestJsonResponse($errorMessages);
        }

        return $this->emptyJsonResponse();
    }
}
