<?php
namespace App\Http\Controllers\Mock;

use Faker\Factory as FakerFactory;
use Illuminate\Http\Request;
use Illuminate\Validation\ValidationException;

/**
 * Class ClaimController
 *
 * @package App\Http\Controllers\Mock
 */
class ClaimController extends BaseMockController
{
    const CLAIM_STATUSES = [
        'Accepted',
        'Rejected',
        'Approved',
        'Closed',
    ];


    /**
     * @param \Illuminate\Http\Request $request
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function getUserClaims(Request $request)
    {
        $userClaims = [];

        $faker = FakerFactory::create();
        if ($faker->boolean(50)) {
            $userClaimsCount = $faker->numberBetween(1, 5);
            for ($i = 1; $i <= $userClaimsCount; ++$i) {
                $userClaims[] = [
                    'id' => $faker->numberBetween(1, 1000),
                    'created_at' => $faker->date() . ' ' . $faker->time(),
                    'need_at' => $faker->date() . ' ' . $faker->time(),
                    'type' => [
                        'id' => $faker->numberBetween(1, 1000),
                        'text' => $faker->sentence(),
                    ],
                    'phone' => $faker->e164PhoneNumber,
                    'status' => self::CLAIM_STATUSES[array_rand(self::CLAIM_STATUSES)],
                ];
            }
        }

        return response()->json([
            'claims' => $userClaims,
        ]);
    }

    /**
     * @param \Illuminate\Http\Request $request
     * @param int $id
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function getClaim(Request $request, $id)
    {
        $faker = FakerFactory::create();

        $userClaim = [
            'id' => $id,
            'created_at' => $faker->date() . ' ' . $faker->time(),
            'need_at' => $faker->date() . ' ' . $faker->time(),
            'type' => [
                'id' => $faker->numberBetween(1, 1000),
                'text' => $faker->sentence(),
            ],
            'phone' => $faker->e164PhoneNumber,
            'status' => self::CLAIM_STATUSES[array_rand(self::CLAIM_STATUSES)],
        ];

        return response()->json([
            'claim' => $userClaim,
        ]);
    }

    /**
     * @param \Illuminate\Http\Request $request
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function getUserClaimTypes(Request $request)
    {
        $faker = FakerFactory::create();

        $UserClaimTypes = [];
        $claimTypesCount = $faker->numberBetween(0, 5);
        for ($i = 1; $i <= $claimTypesCount; ++$i) {
            $UserClaimTypes[] = [
                'id' => $faker->numberBetween(1, 1000),
                'text' => $faker->sentence(),
            ];
        }

        return response()->json([
            'claim_types' => $UserClaimTypes,
        ]);
    }

    /**
     * @param \Illuminate\Http\Request $request
     *
     * @return \Illuminate\Contracts\Routing\ResponseFactory|\Symfony\Component\HttpFoundation\Response
     */
    public function createClaim(Request $request)
    {
        try {
            $this->validate($request, [
                'claim' => 'required|filled',
            ]);
        } catch (ValidationException $validationException) {
            $errorMessages = [];
            $failedValidationRules = $validationException->validator->failed();

            if (isset($failedValidationRules['claim'])) {
                $errorMessages['claim'] = 'Поле Заявка содержит недопустимое значение.';
                if (isset($failedValidationRules['claim']['Required'])) {
                    $errorMessages['claim'] = 'Поле Заявка обязательно для заполнения.';
                }
            }

            return $this->badRequestJsonResponse($errorMessages);
        }

        return $this->emptyJsonResponse();
    }

    /**
     * @param \Illuminate\Http\Request $request
     * @param int $id
     *
     * @return \Illuminate\Contracts\Routing\ResponseFactory|\Symfony\Component\HttpFoundation\Response
     */
    public function updateClaim(Request $request, $id)
    {
        try {
            $this->validate($request, [
                'claim' => 'required|filled',
            ]);
        } catch (ValidationException $validationException) {
            $errorMessages = [];
            $failedValidationRules = $validationException->validator->failed();

            if (isset($failedValidationRules['claim'])) {
                $errorMessages['claim'] = 'Поле Заявка содержит недопустимое значение.';
                if (isset($failedValidationRules['claim']['Required'])) {
                    $errorMessages['claim'] = 'Поле Заявка обязательно для заполнения.';
                }
            }

            return $this->badRequestJsonResponse($errorMessages);
        }

        return $this->emptyJsonResponse();
    }
}
