<?php
namespace App\Http\Controllers\Mock;

use App\Http\Controllers\Controller;
use Illuminate\Http\Response;

/**
 * Class BaseMockController
 *
 * @package App\Http\Controllers\Mock
 */
class BaseMockController extends Controller
{
    const DEFAULT_JSON_RESPONSE_HEADERS = ['Content-Type' => 'application/json'];


    /**
     * @param string $content
     * @param int $status
     * @param array $headers
     *
     * @return \Illuminate\Contracts\Routing\ResponseFactory|\Symfony\Component\HttpFoundation\Response
     */
    public function jsonResponse($content = '', $status = Response::HTTP_OK, array $headers = [])
    {
        return response($content, $status, array_merge(self::DEFAULT_JSON_RESPONSE_HEADERS, $headers));
    }

    /**
     * @param int $status
     * @param array $headers
     *
     * @return \Illuminate\Contracts\Routing\ResponseFactory|\Symfony\Component\HttpFoundation\Response
     */
    public function emptyJsonResponse($status = Response::HTTP_OK, array $headers = [])
    {
        return $this->jsonResponse('', $status, $headers);
    }

    /**
     * @param string $content
     * @param array $headers
     *
     * @return \Illuminate\Contracts\Routing\ResponseFactory|\Symfony\Component\HttpFoundation\Response
     */
    public function badRequestJsonResponse($content = '', array $headers = [])
    {
        return $this->jsonResponse($content, Response::HTTP_BAD_REQUEST, $headers);
    }
}
