<?php
namespace App\Http\Controllers\Mock;

use Faker\Factory as FakerFactory;
use Illuminate\Http\Request;

/**
 * Class AdvertController
 *
 * @package App\Http\Controllers\Mock
 */
class AdvertController extends BaseMockController
{

    /**
     * @return array
     */
    private function getAdvertsList()
    {
        $userAdverts = [];

        $faker = FakerFactory::create();
        if ($faker->boolean(50)) {
            $userAdvertsCount = $faker->numberBetween(1, 5);
            for ($i = 1; $i <= $userAdvertsCount; ++$i) {
                $userAdverts[] = [
                    'id' => $faker->numberBetween(1, 1000),
                    'theme' => $faker->sentence(),
                    'text' => $faker->realText(),
                    'actual_from_date' => $faker->date() . ' ' . $faker->time(),
                    'actual_to_date' => $faker->date() . ' ' . $faker->time(),
                    'is_viewed' => $faker->boolean(50),
                ];
            }

        }

        return $userAdverts;
    }

    /**
     * @param \Illuminate\Http\Request $request
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function getUserAdverts(Request $request)
    {
        return response()->json([
            'adverts' => $this->getAdvertsList(),
        ]);
    }

    /**
     * @param \Illuminate\Http\Request $request
     *
     * @return \Illuminate\Contracts\Routing\ResponseFactory|\Symfony\Component\HttpFoundation\Response
     */
    public function markUserAdvertAsRead(Request $request)
    {
        return $this->emptyJsonResponse();
    }

    /**
     * @param \Illuminate\Http\Request $request
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function getUserAdvertsBoard(Request $request)
    {
        return response()->json([
            'adverts_board' => $this->getAdvertsList(),
        ]);
    }
}
