<?php

namespace App\Http\Controllers\Auth;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Backpack\Base\app\Http\Controllers\Auth\LoginController as BaseLoginController;

class LoginController extends BaseLoginController
{
  /**
   * The user has been authenticated.
   *
   * @param  \Illuminate\Http\Request $request
   * @param  mixed $user
   * @return mixed
   */
  protected $redirectTo = '/admin/dashboard';

  /**
   * Create a new controller instance.
   *
   * @return void
   */
  protected function authenticated(Request $request, $user)
  {
    // If has no permissions in any object - denied login for him
    if (!$user->hasAnyPermissionInAnyObject()) {
      $this->guard()->logout();

      return redirect($this->loginPath)
        ->withErrors(['email' => trans('auth.not_enough_permissions')]);
    }

    // Select first accessible object for user in case hi has not permissions to current object
    $currentObjectId = \App\Models\Building::getFromCookie()->id;
    $accessableObjectsByPermissions = \Illuminate\Support\Facades\Auth::user()->getAccessableObjectsByPermissions();

    if ($request->get('remember')) {
      $user->remember_marker = 1;
    } else {
      $user->remember_marker = 0;
    }
    $user->manual_exit = 0;
    $user->save();

    if ($accessableObjectsByPermissions->search($currentObjectId) === false) {
      return redirect()->route('setobject', ['object' => $accessableObjectsByPermissions->first()]);
    }
  }

  /**
   * Get the needed authorization credentials from the request.
   *
   * @param  \Illuminate\Http\Request $request
   * @return array
   */
  protected function credentials(Request $request)
  {
    $credentials = [
      $this->username() => $request->{$this->username()},
      'password' => $request->password,
      'is_active' => 1
    ];

    return $credentials;
  }

  public function logout(Request $request)
  {
    $user = Auth::user();
    if ($user) {
      $user->remember_marker = 0;
      $user->manual_exit = 1;
      $user->save();

      // Do the default logout procedure
      $this->defaultLogout($request);
    }

    // And redirect to custom location
    return redirect($this->redirectAfterLogout);
  }
}
