<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Carbon\Carbon;

class MessageController extends Controller {

    /**
     * Get count of not viewed quizzes, adverts and notice
     *
     * @return array
     */
    public function count() {
        $user = Auth::user();

        $result = [
            'advert' => 0,
            'quiz' => 0,
            'notice' => 0,
        ];

        // Get User device: this is workaround for getting user's device.
        // See \App\Models\User::device() relation
        $device = $user->device();

        if ($device) {
            $device = $device->first();
        }

        if ($device && $device->apartment) {
            $objectId = $device->apartment->object->id;
            $userId = $user->id;

            $now = Carbon::now();

            // as far as date start/end field names differ in different models,
            // we should use this array
            $dateFieldNames = [
                'advert' => ['actual_from_date', 'actual_to_date'],
                'quiz' => ['start_at', 'end_at'],
                'notice' => ['actual_from_date', 'actual_to_date'],
            ];

            $userApartments = $user->apartments;

            foreach ($result as $entity => &$count) {
                $model = 'App\\Models\\' . ucfirst($entity);
                $dateField = $dateFieldNames[$entity];

                if($entity != 'notice'){
                    $destination = 'App\\Models\\' . ucfirst($entity) . 'Destination';
                    $dt = (new $destination)->getTable();
                    $mt = (new $model)->getTable();
                    $apartments = $destination::where(function ($query) use ($userApartments) {
                        $query->whereIn('apartment', $userApartments->pluck('number'));
                        foreach ($userApartments as $apartment) {
                            $query->orWhere(function ($query) use ($apartment) {
                                $query->where('floor', '=', $apartment->floor);
                                $query->where('entrance', '=', $apartment->entrance);
                            });
                            $query->orWhere(function ($query) use ($apartment) {
                                $query->where('floor', '=', null);
                                $query->where('entrance', '=', $apartment->entrance);
                            });
                            $query->orWhere(function ($query) use ($apartment) {
                                $query->where('floor', '=', $apartment->floor);
                                $query->where('entrance', '=', null);
                            });
                        }
                        $query->orWhere('is_all_house', '=', 1);
                    });

                    $ids = $apartments
                        ->distinct([$dt . '.' . $entity . '_id'])
                        ->rightJoin($mt , $dt . '.' . $entity . '_id', '=', $mt . '.id')
                        ->where(function ($query) use ($mt, $dateFieldNames, $entity, $objectId) {
                            $query->where($mt . '.object_id', '=', $objectId);
                            $query->whereDate($mt . '.' . $dateFieldNames[$entity][0] , '<=', Carbon::now());
                            $query->whereDate($mt . '.' . $dateFieldNames[$entity][1]  , '>=', Carbon::now());
                        })
                        ->get()
                        ->pluck($entity . '_id')->toArray();

                } else {
                    $ids = $model::whereIn('apartment', $userApartments->pluck('number')->toArray())
                        ->where('object_id', '=', $objectId)->get()->pluck('id')->toArray();
                }

                $tmp = $model::where(function ($query) use ($now, $dateField) {
                    $query->whereDate($dateField[0], '<=', $now);
                    $query->whereDate($dateField[1], '>=', $now);
                })
                    ->whereIn('id', $ids)
                    ->whereDoesntHave('viewed', function ($query) use ($userId) {
                        $query->where('user_id', $userId);
                    });
                $count =  $tmp->count();
            }
            unset($count);

            return $result;
        }

        return $result;

        $userId = Auth::user()->id;
        $result = [
            'advert' => 0,
            'quiz' => 0,
            'notice' => 0,
        ];

        $now = Carbon::now();

        // as far as date start/end field names differ in different models,
        // we should use this array
        $dateFieldNames = [
            'advert' => ['actual_from_date', 'actual_to_date'],
            'quiz' => ['start_at', 'end_at'],
            'notice' => ['actual_from_date', 'actual_to_date'],
        ];

        $userApartments = Auth::user()->apartments()->get();

        foreach ($result as $entity => &$count) {
            $model = 'App\\Models\\' . ucfirst($entity);
            $dateField = $dateFieldNames[$entity];

            if($entity != 'notice'){
                $destination = 'App\\Models\\' . ucfirst($entity) . 'Destination';
                $dt = (new $destination)->getTable();
                $mt = (new $model)->getTable();
                $apartments = $destination::where(function ($query) use ($userApartments) {
                    $query->whereIn('apartment', $userApartments->pluck('number'));
                    foreach ($userApartments as $apartment) {
                        $query->orWhere(function ($query) use ($apartment) {
                            $query->where('floor', '=', $apartment->floor);
                            $query->where('entrance', '=', $apartment->entrance);
                        });
                        $query->orWhere(function ($query) use ($apartment) {
                            $query->where('floor', '=', null);
                            $query->where('entrance', '=', $apartment->entrance);
                        });
                        $query->orWhere(function ($query) use ($apartment) {
                            $query->where('floor', '=', $apartment->floor);
                            $query->where('entrance', '=', null);
                        });
                    }
                    $query->orWhere('is_all_house', '=', 1);
                });

                $ids = $apartments
                    ->distinct([$dt . '.' . $entity . '_id'])
                    ->rightJoin($mt , $dt . '.' . $entity . '_id', '=', $mt . '.id')
                    ->where(function ($query) use ($mt, $dateFieldNames, $entity) {
                        $query->whereDate($mt . '.' . $dateFieldNames[$entity][0] , '<=', Carbon::now());
                        $query->whereDate($mt . '.' . $dateFieldNames[$entity][1]  , '>=', Carbon::now());
                    })
                    ->get()
                    ->pluck($entity . '_id')->toArray();

            } else {
                $ids = $model::whereIn('apartment', $userApartments->pluck('number')->toArray())->get()->pluck('id')->toArray();
            }

            $tmp = $model::where(function ($query) use ($now, $dateField) {
                    $query->whereDate($dateField[0], '<=', $now);
                    $query->whereDate($dateField[1], '>=', $now);
                })
                ->whereIn('id', $ids)
                ->whereDoesntHave('viewed', function ($query) use ($userId) {
                    $query->where('user_id', $userId);
                });
            $count =  $tmp->count();
        }
        unset($count);

        return $result;
    }
}
