<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Storage;
use Intervention\Image\Facades\Image;

class MediaController extends Controller
{
    public function getImage($image_name)
    {
        if(!empty($image_name)) {
            $exists = Storage::disk('public')->exists($image_name);

            if($exists) {
                return Image::make(Storage::disk('public')->get($image_name))->response();
            }
        }

        abort(404);
    }
}
