<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use evApps\Installer\app\Http\Utilities\Installer;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Artisan;

/**
 * Class LicenseController
 *
 * @package App\Http\Controllers\Api
 */
class LicenseController extends Controller
{

    /**
     * @param \Illuminate\Http\Request $request
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function updateLicense(Request $request)
    {
        $request->validate([
            'newKey' => 'required',
        ]);

        // Update license key in .env file
        Installer::updateEnv(['APP_LICENSE_KEY' => $request->input('newKey')]);
        Artisan::call('config:clear');

        return response()->json([]);
    }
}
