<?php

namespace App\Http\Controllers\Api;

use App\Models\ApartmentSipNumber;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Config;
use Illuminate\Support\Facades\Validator;

class DeviceController extends Controller
{
    protected function validateAndUpdate(Request $request, $rules)
    {
        $this->validate($request, $rules);

        $device = $request->user()->device();

        $device->update($request->all());

        return $device->first();
    }

    public function pushtoken(Request $request)
    {
        $rules = [
          'push_token' => 'required|max:255',
          'is_ios' => 'max:1',
        ];

        return $this->validateAndUpdate($request, $rules);
    }

    public function getSipNumber(Request $request)
    {
        $device = $request->user()->device()->first();

        $sip_client_number = null;
        $sip_client_password = null;
        list($sip_server_address, $sip_server_port, $concierge_sip_number) = array_values(Config::getMany([
            'settings.sip_server_address',
            'settings.sip_server_port',
            'settings.concierge_sip_number',
        ]));

        $sipNumber = ApartmentSipNumber::find($device->sip_number_id);

        if ($sipNumber) {
            $sip_client_number = (string)$sipNumber->sip_number;
            $sip_client_password = (string)$sipNumber->sip_password;
        }

        if ($device->apartment) {
            $object = $device->apartment->object;
            $sip_server_address = $object->sip_server_address;
            $sip_server_port = $object->sip_server_port;
            $concierge_sip_number = $object->concierge_sip_number;
        }
        return array_merge($request->user()->toArray(), [
            'sip_server_address' => $sip_server_address,
            'sip_server_port' => $sip_server_port,
            'concierge_sip_number' => $concierge_sip_number,
            'sip_client_number' => $sip_client_number,
            'sip_client_password' => $sip_client_password
        ]);
    }

    public function locale(Request $request)
    {
//        if ($request->isMethod('get')) {
//            return $request->user()->device()->first();
//        }
//
//        $rules = [
//          'locale' => 'required|in:ru,en,ua',
//        ];
//
//        return $this->validateAndUpdate($request, $rules);
//        return response()->json([
//            'error' => [
//                'code' => 422,
//                'message' => 'The given data was invalid.',
//                'errors' => [
//                    'locale' => $validator->messages()->messages
//                ]
//            ]
//        ]);

        if ($request->isMethod('get')) {
            return $request->user()->device()->first();
        }

        $validator = Validator::make($request->all(), [
            'locale' => 'required|in:ru,en,ua,lv',
        ]);

        if ($validator->fails()) {
            $request->request->add(['locale' => 'en']);

            $device = $request->user()->device();
            $device->update($request->all());

            return response()->json([
                'error' => [
                    'code' => 422,
                    'message' => 'The given data was invalid.',
                    'errors' => [
                        'locale' => $validator->messages()->messages()
                    ]
                ]
            ]);
        } else {
            $device = $request->user()->device();
            $device->update($request->all());

            return response()->json($device->first());
        }
    }

}
