<?php

namespace App\Http\Controllers\Api;


use App\Http\Controllers\Controller;
use App\Models\CallingPanel;
use App\Models\User;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Config;

class CallingPanelController extends Controller
{
    public function index()
    {
        $apartment_id = Auth::user()->device()->first()->apartment->id;

        return CallingPanel::whereHas('apartments', function($q) use($apartment_id) {
            $q->where('id', $apartment_id);
            })->where('object_id', Config::get('app.object.id'))
            ->get();
    }
}
