<?php

namespace App\Http\Controllers\Api;

use App\Models\Apartment;
use App\Models\Building;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Auth;

class BuildingController extends Controller
{
    /**
     * Вернуть модель объекта для авторизовавшегося пользователя в соответствии с переданной локализацией
     *
     * Получаем авторизованного пользователя (который авторизовался через мобильное приложение)
     * Зная его устройство, получаем номер квартиры и, соответственно, идентификатор объекта
     * Возвращаем локализованный объект
     *
     * В случае ошибки (не нашлось устройство в бд или квартира) возвращается локализованный ответ с кодом 422
     *
     * @param Request $request
     * @return Building|\Illuminate\Http\JsonResponse|mixed
     */
    public function model(Request $request)
    {
        // Настройки
        $user = Auth::user();
        $code = 422;

        // Условия необходимы на случай повреждений в базе данных, для возвращения корректного ответа об ошибке
        if ($devices = $user->device) {
            $device = $devices->first();
            $locale = $device->locale;

            App::setLocale($locale);

            if (($apartment = Apartment::find($device->apartment_id)) && ($building = Building::find($apartment->object_id))) {
                // Запомнить значения имени и адреса для текущей локализации
                $name = $building->name;
                $address = $user->getAddressAttribute();

                // Отключить translatable поля
                $building->translatable = null;

                // Присвоить новую локализацию
                $building->name = $name;
                $building->address = $address;

                return $building;
            } else {
                // Сформировать ответ в случае ошибки
                return response()->json(['message' => trans('device.api.db')], $code);
            }

            return Building::find($device->apartment_id);
        }

        // Так как невозможно установить локализацию, не зная устройства, возвращаем корректную ошибку на языке, прянятом поумолчанию
        App::setLocale(config('app.fallback_locale'));
        return response()->json(['message' => trans('device.api.db'), $code]);
    }
}
