<?php

namespace App\Http\Controllers\Api;

use App\Models\Apartment;
use App\Models\Device;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;

class ApartmentController extends Controller
{
  public function getActivationsData(Request $request)
  {
    $user = Auth::user();

    if ($user) {
      $device = $user->device();

      if ($device) {
        $device = $device->first();

        if ($device instanceof Device) {

          if ($device->apartment) {
            $limit_of_activations = $device->apartment->activation_limit;
            $number_of_activations = $device->apartment->getActivationsUsed();

            return [
              'limit_of_activations' => $limit_of_activations,
              'number_of_activations' => $number_of_activations
            ];
          }
        } else {
          return [
            'error' => 'Cannot find device'
          ];
        }
      }
    }

    return [];
  }

  public function saveActivationCode($id, Request $request)
  {
    $fields = $request->all();
    if (!$id || !isset($fields['activation_code'])) {
      abort(400);
    }
    $apartment = Apartment::findOrFail($id);
    $apartment->activation_code = $fields['activation_code'];
    $apartment->save();
    return $apartment->toArray();
  }

  public function saveActivationCodes(Request $request)
  {
    $fields = $request->all();
    if (empty($fields)) {
      abort(400);
    }
    $arApartments = [];
    foreach ($fields as $id => $code) {
      $apartment = Apartment::findOrFail($id);
      $apartment->activation_code = $code;
      $apartment->save();
      $arApartments[] = $apartment->toArray();
    }
    return $arApartments;
  }
}
