<?php

namespace App\Http\Controllers\Admin;

use App\Models\PermissionManager\Permission;
use App\Traits\PermissionManager\CheckingPermissions;
use Backpack\PermissionManager\app\Http\Controllers\PermissionCrudController as BasePermissionCrudController;

class PermissionCrudController extends BasePermissionCrudController
{
    use CheckingPermissions;

    public function __construct()
    {
        parent::__construct();

        $this->applyCheckingPermissions([[
            [Permission::PERMISSIONS_VIEW_ACCESS],
            ['index'],
        ]]);
    }

    public function setup()
    {
        $this->crud->removeAllButtons();
        
        parent::setup();

        $this->crud->addColumn([
            'name'  => 'name',
            'label' => trans('backpack::permissionmanager.name'),
            'type'  => 'text',
            'orderable' => false

        ]);

        // Make columns translatable
        $this->crud->columns['name']['name'] = 'translated_name';

        $this->applyBackpackPermissions();
    }

    public function show($id){
        Abort(404);
    }
}
