<?php

namespace App\Helpers;
use App\Models\Apartment;

/**
 * Class Object
 *
 * @package App\Helpers
 */
class Objects
{
    /**
     *
     * @return bool
     */
    public static function isEmpty()
    {
        $object_id = config('app.object.id');

        if($object_id) {
            $apartments_count = Apartment::where('object_id', $object_id)
                ->where('is_local', 0)
                ->count();

            if($apartments_count !== 0) {
                return false;
            }
        }

        return true;
    }

    public static function isApartmentsSaving()
    {
        $object_id = config('app.object.id');

        if($object_id) {
            $apartments_count = Apartment::where('object_id', $object_id)
                ->where('is_save', 1)
                ->count();

            if($apartments_count !== 0) {
                return false;
            }
        }

        return true;
    }

    public static function apartmentsSavingCount()
    {
        $object_id = config('app.object.id');

        if($object_id) {
            $apartments_count = Apartment::where('object_id', $object_id)
                ->where('is_local', 1)
                ->where('is_save', 1)
                ->count();

            return $apartments_count;
        }

        return 0;
    }
}
